-- Define our particle characteristics
pVelocity = Allocate(2) ; -- Allocate a Vec2 velocity member
pAge = Allocate(1) ; -- Allocate a Vec2 velocity member
pSpin = Allocate(1); -- Allocate a TReal spin member
pSpinSpeed = Allocate(1); -- Allocate a TReal spin member

-- Set the particle texture
SetTexture("heartboost");
SetBlendMode(kBlendNormal);

SetNumParticles(5);    -- Create some particles

pPosition:Init(  Vec2(0,0) );
pVelocity:Init( fRange( Vec2(-50,-100), Vec2(50,-120) ) );
pColor:Init( Color(1,1,1,1) );
pScale:Init( 0.5 );
pSpin:Init( fRange( 0, 1.5 ) );
pSpinSpeed:Init( fRange( -5, 5 ) );
pUp:Anim( f2dRotation( pSpin ) );

pColor:Anim( fFade( pAge,Color(1,1,1,1), 1500, Color(1,1,1,0) ) );
pPosition:Anim( pPosition + fTimeScale(pVelocity) );
pPosition:Anim( pPosition );
pScale:Anim( pScale + fTimeScale(1) );
pVelocity:Anim( pVelocity + fTimeScale(Vec2(0,120)) );
pSpin:Anim( pSpin + fTimeScale( pSpinSpeed ) );

-- Add time to the age
pAge:Anim( pAge+fAge() );

-- Expire particles over 1500 ms old
Anim( fExpire( fGreater(pAge,1500) ) );

-- Variable to control emission
gEmitParticles = true;


-- A function to run as we're executing
-- seconds - how many seconds have elapsed
function Update(seconds)
   -- Create 10 particles per second
   if gEmitParticles then
      if mytimer == nil then
         mytimer = NewTimeout(1);
     elseif not mytimer(seconds) then 
         CreateParticles( seconds * 10 );
    else
         gEmitParticles = false;
         mytimer = nil;
    end
   end
end

